<?php
/**
 * Simple utility to stop processes over running each other
 */
class LockUtil {

	public function lock($key) {
		if (!is_dir(TMP . 'lock')) {
			mkdir(TMP . 'lock');
		}
		$lockFile = TMP . 'lock' . DS . $key;

		if (file_exists($lockFile)) {
			if ($this->running(file_get_contents($lockFile))) {
				echo __('action is already running', true);
				return false;
			}
		}
		file_put_contents($lockFile, getmypid());
		return true;
	}

	public function unlock($key) {
		$lockFile = TMP . 'lock' . DS . $key;
		if (file_exists($lockFile)) {
			unlink($lockFile);
		}
		return true;
	}

/**
 * Checks if the process is locked by checking if there is a lock file and then
 * whether the PID is still going
 * @param  [type] $pid [description]
 * @return [type]      [description]
 */
	public function running($pid) {
		if (stristr(PHP_OS, 'WIN')) {
			if (`tasklist /fo csv /fi "PID eq $pid"`) {
				return true;
			}
		} else {
			if (in_array($pid, explode(PHP_EOL, `ps -e | awk '{print $1}'`))) {
				return true;
			}
		}
		return false;
	}

}
