<?php

App::uses('QueueTask', 'Queue.Console/Command/Task');
App::uses('CustomEmail', 'Lib');
App::uses('LockUtil', 'Routable.Lib');

/**
 * A Simple QueueTask example.
 *
 */
class QueueRouteTask extends QueueTask {

/**
 * "Add" the task, not possible for QueueEmailTask
 *
 * @return void
 */
	public function add() {
		// Add Rebuild job to the queue
		$QueuedTask = EvClassRegistry::init('Queue.QueuedTask');

		$QueuedTask->createJob(
			'Route'
		);

		// Clear any duplicates so it doesn't run rebuild twice
		$QueuedTask->clearDoublettes();
	}

/**
 * QueueEmailTask::run()
 *
 * @param mixed $data Job data
 * @param int $id The id of the QueuedTask
 * @return bool Success
 */
	public function run($data, $id = null) {
		// Check if a rebuild is already going on
		$LockUtil = new LockUtil();
		if ($LockUtil->lock('routeRebuild')) {
			$Route = EvClassRegistry::init('Routable.Route');
			$rebuildResult = $Route->updateDynamicRoutesCache();
			if ($Route->getDatasource()->isConnected() === false) {
				$Route->getDatasource()->reconnect();
			}
			$LockUtil->unlock('routeRebuild');
			return $rebuildResult;
		} else {
			$this->out('Queue task is already running');
			return false;
		}
	}

}
