<?php

App::uses('Route', 'Routable.Model');

class RoutesShell extends AppShell {

	public function main() {
		echo "Please run \"rebuild [[MODEL]]\"	";
	}

/**
 * Rebuilds the routes for a specified model by looping through and assiging a route.
 * If no model is passed it just creates a job in the queue to rebuild the dynamic_routes.php file
 * @return void
 */
	public function rebuild() {
		if (isset($this->args[0])) {

			if (strpos($this->args[0], ',') !== false) {
				$models = explode(',', $this->args[0]);
			} else {
				$models = [$this->args[0]];
			}

			if (!empty($models)) {
				$Route = EvClassRegistry::init('Routable.Route');

				foreach ($models as $model) {
					$Model = EvClassRegistry::init($model);

					if ($Model) {
						$results = $Model->find('all');
						$this->out(__('Creating new routes for %s', $model));

						foreach ($results as $result) {
							$this->_createRouteForModel($result, $Model, $Route);
						}
					} else {
						$this->out(__('Could not find model for %s', $model));
					}
				}
			} else {
				$this->out(__('Could not find models to rebuild'));
			}

			$this->out('');
			$this->out('Route building complete.');
			$this->hr();
		} else {
			$this->out('No model specified rebulding dynamic_routes.php');
		}

		$this->_queueRouteRebuild();
	}

/**
 * Function to queue up a route rebuild which in turn generates the dynamic_route.php file
 * It is only queued up if there isn't already the same task in the queue
 * @return void
 */
	protected function _queueRouteRebuild() {
		//Create Route task
		$QueuedTask = EvClassRegistry::init('Queue.QueuedTask');

		$jobExists = $QueuedTask->find(
			'first',
			[
				'conditions' => [
					'QueuedTask.jobtype' => 'Route',
					'QueuedTask.fetched' => null
				]
			]
		);

		if (empty($jobExists)) {
			$QueuedTask->createJob(
				'Route'
			);
		}
	}

/**
 * Creates a route for a given model item
 * @param array  $modelItem Model item data
 * @param Object $Model     CakePHP Model instance
 * @param Object $Route     CakePHP Route Model instance
 * @return void
 */
	protected function _createRouteForModel($modelItem, $Model, $Route) {
		if ($Model->hasBehavior('Routable.Routable')) {

			$Model->data = $modelItem;

			$data['Route']['actual'] = $Model->actual($modelItem);
			// $data['Route']['alias'] = $Model->alias(null);

			// create a unique alias
			$baseAlias = $Model->alias(null);

			$suffix = 0;

			do {
				$suffix++;

				$alias = $baseAlias;
				if ($suffix > 1) {
					$alias = $Model->alias($suffix);
				}

				$found = $Route->findByAlias($alias);

			} while ($found);

			$data['Route']['alias'] = $alias;

			$Route = new Route();

			// Create/Update the route.

			// @TODO: There's a potential race condition here, someone else may
			// have just inserted the same route (unlikely). In this scenariom the
			// $Model will have saved, but the route won't.
			$Route->create();
			$Route->save(
				$data,
				[
					'callbacks' => false
				]
			);
		}
	}
}
