<?php

App::uses('RoutableAppModel', 'Routable.Model');

/**
 * Dynamic Routes model
 */
class Route extends RoutableAppModel {

/**
 * Default display field
 */
	public $displayField = "alias";


/**
 * Default validation rules
 */
	public $validate = array(
		'alias' => array(
			'unique' => array(
				'rule' => 'isUnique',
				'message' => 'must be unique',
				'allowEmpty' => true
			)
		)
	);

/**
 * Update the dynamic route cache
 */
	public function afterSave($created, $options=array()) {
		if (Configure::read('Routable.disable_rebuild') != '1') {
			$this->_updateDynamicRoutesCache();
		} else {
			$settingsModel = ClassRegistry::init('SiteSettings.SiteSetting');
			$setting = $settingsModel->find('first', array(
				'conditions' => array(
					'name' => 'rebuild_routes'
				)
			));

			$setting['SiteSetting']['value'] = '1';
			$settingsModel->save($setting);
		}
	    return parent::afterSave($created, $options);

	}


/**
 * Recreate the dynamic routes cache file
 *
 * @todo Doesn't work correctly for actual 'admin'
 * @todo This might hit PHP's script timeout for very large routing files - also may hit an out of memory too
 *
 */
	public function _updateDynamicRoutesCache() {

		$routes = $this->find('all');

		$cache = "<?php\n";

		foreach ($routes as $route) {

			$alias = $route['Route']['alias'];

			// Check that the tokens have been removed from the alias before proceeding
			// (this shouldn't happen, but we want to catch it if it does).
			if (strrpos($alias, ':')===false) {

				$actual = Router::parse($route['Route']['actual']);

				$cache .= "Router::connect('/" . $alias . "', array(";

				foreach ($actual as $key=>$value) {

					if (!empty($value)) {

						if (is_array($value)) {

							foreach($value as $key1=>$param) {

								//handles pass variable
								if(is_numeric($key1)) {

									$cache .= "'" . $param . "',";

								//Handles Named params
								} else {

									$cache .= "'" . $key1 . "'=>'" . $param . "',";

								}

							}

						}
						else {

							$cache .= "'" . $key . "'=>'" . $value . "',";

						}

					}

				}

				$cache = substr($cache, 0, -1) . "));\n";

			}

		}


		$fh = fopen(TMP . 'dynamic_routes.php', 'w');
		fwrite($fh, $cache);
		fclose($fh);

	}

}
