<?php

App::uses('RoutableAppModel', 'Routable.Model');

class Redirect extends RoutableAppModel {

/**
 * Default display field
 */
	public $displayField = 'source';

/**
 * Validation rules for the model
 */
	public $validate = array(
		'source' => array(
			'required' => array(
				'rule' => 'notBlank',
				'message' => 'cannot be blank'
			)
		),
		'destination' => array(
			'required' => array(
				'rule' => 'checkDestination',
				'message' => 'cannot be blank'
			)
		)
	);


/**
 * Validation method, applies required validation rule on field when the
 * redirect is not associated with another model.
 *
 * @param  array $check
 * @return boolean
 */
	public function checkDestination($check) {

		if (empty($this->data[$this->name]['model']) && empty($this->data[$this->name]['model_id'])) {

			$value = array_shift($check);

			return !empty($value);

		}

		return true;

	}


/**
 * Check if there is a redirect setup for a given URL.
 *
 * @param  string $url original/source URL
 * @return array
 */
	public function findRedirect($url) {

		$data = $this->find('first', array(
			'conditions' => array(
				'Redirect.source' => $url,
				'Redirect.is_active' => true
			),
			'order' => array('Redirect.modified' => 'DESC')
		));

		// Check if we need to build the destination URL.
		if (
			! empty($data['Redirect']['model']) &&
			! empty($data['Redirect']['model_id']) &&
			! empty($data['Redirect']['action'])
		) {
			$controller = Inflector::tableize($data['Redirect']['model']);

			$data['Redirect']['destination'] = Router::url(array(
				'controller' => $controller,
				'action' => $data['Redirect']['action'],
				$data['Redirect']['model_id']
			));

		}

		return $data;

	}

}
