<?php

class RouterUtil
{
	/**
	 * get the route for plugin item
	 * check the configs
	 *
	 * @param 	string 		the Config to look
	 * @param 	string 		(optional) the specific model to look for
	 * @return 	array 		A routing array to load
	 */
	public static function getItemRoute($configName, $model = false)
	{
		$config = $configName . '.route';
		if (isset($model) && ! empty($model)) {

			$config .= '.' . $model;
		}

		if (empty($configName) || ! Configure::check($config)) {

			return array();
		}

		$configRoute = Configure::read($config);

		if (! empty($configRoute)) {

			list($plugin, $controller) = pluginSplit($configRoute['controller']);
			$configRoute['plugin'] = $plugin;
			$configRoute['controller'] = $controller;

			return $configRoute;
		} else {

			return array();
		}
	}

	/**
	 * get the route for plugin listing page
	 * check the configs
	 *
	 * @param 	string 		the Config to look
	 * @param 	string 		(optional) the specific model to look for
	 * @param 	string 		(optional) the listing action, defaults to index
	 * @return 	array 		A routing array to load
	 */
	public static function getListingRoute($configName, $model = false, $action = 'index')
	{
		$config = $configName . '.route';
		if (isset($model) && ! empty($model)) {

			$config .= '.' . $model;
		}

		if (empty($configName) || ! Configure::check($config)) {

			return array();
		}

		$configRoute = Configure::read($config);

		if (! empty($configRoute)) {

			list($plugin, $controller) = pluginSplit($configRoute['controller']);
			$configRoute['plugin'] = $plugin;
			$configRoute['controller'] = $controller;
			$configRoute['action'] = $action;

			return $configRoute;
		} else {

			return array();
		}
	}

}
