RoutablePlugin - Multi-Site Version
====================================
This plugin automatically handles dynamic (database driven) routes for models. It is based off of the Routable plugin used on standard sites, with modifications for multi-domain support.

Usage
------
The only main difference between this plugin and the original is the multi-site support. To use this plugin, you should have a sites table that stores the domains. From that you can, however you wish, work out what site the user is currently on.

For your tables, and for the admin CRUD system, add a 'site_id' field. This will be used when generating and saving routes to determin which site's dynamic_routes.php file to use

Shared Routes
--------------
The plugin will recognise routes with a site id of zero (not null) as being 'global' routes and will make them available across all sites.


Original Setup Instructions
==========================
The below instructions are provided for historic purposes only and are not up to date or needed is most situations.

Setup:

	Schema:
	

		
	Load the plugin:
	
		Add the following to /app/Config/bootstrap.php:
		
			CakePlugin::loadAll(array(
			    'Routable'=>array(
			        'routes'=>true,
			    )
			));
		
		If you remove the 'routes'=>true line if you can still access the 
		Routes controller methods from /routables/routes/*
		 
		If you leave it in, you can access them from the more natural /routes/*
		
	Load dynamic routes:
	
		Add the following to app/Config/routes.php after your application 
		custom routes and before CakePlugin::routes();
		
			if (file_exists(TMP . "dynamic_routes.php")) {
			
			    require_once(TMP . "dynamic_routes.php");
			
			}	

		Note, you can manage all your application custom routes using this 
		plugin too - no need to add them by hand to /app/routes.php 
		
		
		
Usage:

	Attach the behavior to your model:
	
		class MyModel extends AppModel {
		
			public $actsAs = array(
				'Routable.Routable'
			);
		
		}
	
	By default, the behavior will create alias URL's based on the controller and 
	the model's displayField and actual URLs based on the controller, the view 
	action and the primaryKey of the Model.
	
		e.g. alias:  /events/my_event_name
			 actual: /events/view/1
			 
	You can override this behavior by setting the actual and alias templates 
	yourself when you attach the behavior:
	
		public $actsAs = array(
			'Routable.Routable'=>array(
				'alias'=>'fred/barney/wilma',
				'actual'=>'foo/bar/baz'
			)
		);
	
		Each part of the url paths can be replaced with dynamic tokens:
			
			:controller - the controller associated with the Model
			:action - the action defined for the model's routable behaviour
			:displayField - the displayField field associated with the Model
			:primaryKey - the primary key field associated with the Model
			:field_name - any field from the Model
			
			e.g.
			
				'alias'=>':controller/:name',
				'actual'=>':controller/:action/:id'
				
			Will create routes like 'events/my_event_name' -> 'events/view/1
			(using the name of the controller and the value ofthe name field 
			in the alias, and the name of the controller and the value of the 
			id field in the actual url
			
			Most of the time, you only need to configure the alias
			
	Adding the routes fields to your Model forms:
	
		If you want your allow your users to specificy their own alias' for a 
		record, add the following fields to your add/edit forms.
		 
		In your add/edit forms, add the following fields:
	
			$this->Form->inputs(array(
				'Route.id'=>array(
					'type'=>'hidden'
				),
				'Route.alias'
			);

		If the user doens't specificy an alias, the behaviour will generate one
		using the template you specificy when you attach it.
		
		The alias will be validated for it's uniqueness automatically.

	If you are building routes with an action other than 'view' you need to set this
	when you include the behaviour:
	
		public $actsAs = array(
			'Routable.Routable'=>array(
				'action'=>'display'
			)
		);

	The action is also used to generate redirect URLs.
		