<?php

App::uses('RoutableAppModel', 'Routable.Model');
App::uses('CakeSession', 'Model/Datasource');

/**
 * Dynamic Routes model
 */
class Route extends RoutableAppModel {

	public $validate = array(
		'alias' => array(
			'rule' => 'validateUniqueRow',
			'message' => 'Another page on this site has the same URL'
		)
	);

/**
 * Default display field
 */
	public $displayField = "alias";

/**
 * Update the dynamic route cache
 */
	public function afterSave($created, $options = array()) {
		$siteId = CakeSession::read('siteId');
		$this->_updateDynamicRoutesCache($siteId);

		return parent::afterSave($created, $options);
	}

/**
 * Custom function to validate uniqueness of alias/site ID combo
 * Runs on route save
 */
	public function validateUniqueRow($check) {
		$currenRouteID = $this->data['Route']['id'];
		$siteID = $this->data['Route']['site_id'];
		$alias = $this->data['Route']['alias'];

		$conditions = array(
			'alias' => $alias,
			'site_id' => $siteID
		);

		if (isset($this->data['Route']['id'])) {
			$conditions['NOT'][] = array('id' => $this->data['Route']['id']);
		}

		$match = $this->find('first', array(
			'conditions' => $conditions
		));

		return empty($match) ? true : false;
	}

/**
 * Function to get the multisite route for a page
 * @param string $actual the "actual" route to check against
 * @param (int) $siteId the site ID we're checking against
 */
	public function getMultisiteRoute($actual, $siteId) {
		$route = $this->find('first', array(
			'conditions' => array(
				'actual' => $actual,
				'OR' => array(
					'site_id' => $siteId,
					'site_id IS NULL'
				)
			)
		));

		return $route;
	}

/**
 * Recreate the dynamic routes cache file
 *
 * @todo Doesn't work correctly for actual 'admin'
 * @todo This might hit PHP's script timeout for very large routing files - also may hit an out of memory too
 *
 */
	protected function _updateDynamicRoutesCache($siteId) {
		$routes = $this->find('all');

		// Extract the site ids and splot the above into multiple sub-arrays (one for each site id)
		$siteRoutes = array();

		if (! empty($routes)) {
			foreach ($routes as $route) {
				$siteRoutes[$route['Route']['site_id']][] = $route;
			}
		}

		foreach ($siteRoutes as $siteId => $routes) {
			$cache = $this->_buildRoutesCache($routes);

			$filePath = TMP . 'dynamic_routes' . DS . 'dynamic_routes_' . $siteId . '.php';

			// If there is no site id, use the main dynamic routes file instead as it means it's a shared route.
			if ($siteId <= 0) {
				$filePath = TMP . 'dynamic_routes.php';
			}

			$fh = fopen($filePath, 'w');
			fwrite($fh, $cache);
			fclose($fh);
		}
	}

	/**
	 * loops through the passed routes and builds up a cache string ready to save
	 * @param  [type] $routes [description]
	 * @return [type]         [description]
	 */
	protected function _buildRoutesCache($routes) {
		$cache = "<?php\n";

		foreach ($routes as $route) {

			$alias = $route['Route']['alias'];

			// Check that the tokens have been removed from the alias before proceeding
			// (this shouldn't happen, but we want to catch it if it does).
			if (strrpos($alias, ':') === false) {

				$actual = Router::parse($route['Route']['actual']);

				$cache .= "Router::connect('/" . $alias . "', array(";

				foreach ($actual as $key => $value) {

					if (!empty($value)) {

						if (is_array($value)) {

							foreach ($value as $key1 => $param) {

								//handles pass variable
								if (is_numeric($key1)) {

									$cache .= "'" . $param . "',";

									// Handles Named params
								} else {

									$cache .= "'" . $key1 . "'=>'" . $param . "',";

								}

							}

						} else {

							$cache .= "'" . $key . "'=>'" . $value . "',";

						}

					}

				}

				$cache = substr($cache, 0, -1) . "));\n";

			}

		}

		return $cache;
	}
}