<?php

class RedirectsController extends RoutableAppController {

/**
 * Prepare the admin form fields for the redirect item form.
 *
 * @return array
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		unset($fields['model']);
		unset($fields['action']);
		unset($fields['model_id']);

		return $fields;
	}

/**
 * Define the columns we want displayed in the admin listings.
 *
 * @return array
 */
	protected function _adminIndexColumnsWhitelist() {
		$columns = parent::_adminIndexColumnsWhitelist();

		// We want to include the redirect destination column in the admin
		// listings.
		$columns[] = 'Redirect.destination';

		return $columns;
	}

/**
 * Redirect edit page.
 *
 * @param  integer $id redirect ID
 */
	public function admin_edit($id = null) {
		parent::admin_edit($id);

		// If we're dealing with a redirect associated to another model
		// then we want to remove the destination field from the form. We need
		// to do this directly as the view variables have already been
		// set.
		if (!empty($this->request->data['Redirect']['model'])) {
			unset($this->viewVars['fields']['destination']);
		}

		return;
	}
}
