<?php
class RoutesShell extends AppShell {

	public function main() {
		echo "Please run \"rebuild [[MODEL]]\"	";
	}

	public function rebuild() {
		if (isset($this->args[0])) {
			$model = $this->args[0];

			$Model = EvClassRegistry::init($model);

			if ($Model) {
				$results = $Model->find('all');
				$this->out(__('Creating new routes for %s...', $model));

				foreach ($results as $result) {
					$Model->id = $result[$Model->alias]['id'];
					$data = $result[$Model->alias];
					$data['modified'] = false;
					$Model->save($data);
				}

				$this->out('');
				$this->out('Route building complete.');
				$this->hr();
			}
		} else {

			$this->out('Please specify a model');
		}
	}
}
