<?php
class UpdatedForMultisiteSupport extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'updated_for_multisite_support';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'redirects' => array(
					'site_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'after' => 'is_active'),
				),
				'routes' => array(
					'site_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'after' => 'actual'),
				),
			),
			'alter_field' => array(
				'redirects' => array(
					'source' => array('type' => 'string', 'null' => false, 'default' => null, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
			),
			'drop_field' => array(
				'routes' => array('indexes' => array('alias_UNIQUE')),
			),
		),
		'down' => array(
			'drop_field' => array(
				'redirects' => array('site_id'),
				'routes' => array('site_id'),
			),
			'alter_field' => array(
				'redirects' => array(
					'source' => array('type' => 'string', 'null' => false, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
			),
			'create_field' => array(
				'routes' => array(
					'indexes' => array(
						'alias_UNIQUE' => array('column' => 'alias', 'unique' => 1),
					),
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
