<?php

	echo $this->Form->create();

	// Important! Make sure the form sets Form.process to 'EvReview.add_review'
	// to ensure that it gets processed.
	echo $this->Form->hidden('Form.process', ['value' => 'EvReview.add_review']);
	
	echo $this->Form->input('Review.name', ['label' => __('Name')]);
	echo $this->Form->input('Review.email', ['label' => __('Email'), 'type' => 'email']);
	echo $this->Form->input('Review.email_confirm', ['style' => 'display:none', 'autocomplete' => 'off']);
	echo $this->Form->input('Review.location', ['label' => __('Location')]);
	echo $this->Form->input('Review.title', ['label' => __('Review Title')]);
	echo $this->Form->input('Review.review', ['label' => __('Your Review'), 'type' => 'textarea']);

	$ratingOptions = [1 => '1', 2 => '2', 3 => '3', 4 => '4', 5 => '5'];
	echo $this->Form->input('Review.rating', ['options' => $ratingOptions, 'label' => __('Rating'), 'type' => 'radio', 'class' => 'ev_review_rating']);

	$recommendOptions = [1 => 'Yes', 0 => 'No'];
	echo $this->Form->radio('Review.recommend', $recommendOptions, ['legend' => __('Would you recommend this to a friend?'), 'type' => 'radio']);

	echo $this->Form->submit(__('Leave Review'));

	echo $this->Form->end();