<?php

class ReviewableBehavior extends ModelBehavior {

	public $settings = array();

/**
 * Configuration method. Sets up model associations with the Review model.
 * 
 * @param object $Model
 * @param array $config
 * @return void
 */
	public function setup(Model $Model, $config = []) {

		parent::setup($Model, $config);

		$this->settings[$Model->alias] = $config;

		if (empty($this->settings[$Model->alias]['plugin'])) {
			$this->settings[$Model->alias]['plugin'] = $Model->plugin;
		}
		if (empty($this->settings[$Model->alias]['model'])) {
			$this->settings[$Model->alias]['model'] = $Model->name;
		}

		$Model->hasMany['Review'] = array(
			'className' => 'EvReview.Review',
			'foreignKey' => 'model_id',
			'conditions' => array(
				'model' => $this->settings[$Model->alias]['model']
			),
			'dependent' => true,
			'cascade' => true
		);

		$Model->hasOne['RatingAverage'] = array(
			'className' => 'EvReview.RatingAverage',
			'foreignKey' => 'model_id',
			'conditions' => array(
				'model' => $this->settings[$Model->alias]['model']
			),
			'dependent' => true,
			'cascade' => true
		);

		return;

	}


/**
 * Returns all active reviews for the current model item.
 * 
 * @param object $Model
 * @param integer $id
 * @param array $params query parameters
 * @return array
 */
	public function reviews(Model $Model, $id, $params = []) {

		// Set the default query parameters.
		$defaultParams = array(
			'conditions' => array(
				'Review.is_active' => true
			)
		);

		$params = array_merge_recursive($defaultParams, $params);

		return $Model->Review->find('all', $params);

	}

}