<?php

App::uses('CakeEventListener', 'Event');
App::uses('CustomEmail', 'Lib');

class ReviewListener implements CakeEventListener {

	public function implementedEvents() {

		return array(
			'Model.Review.submitted' => 'reviewSubmitted'
		);

	}


/**
 * Sends a notification email when a review is submitted.
 * 
 * @param object $event
 * @return void
 */
	public function reviewSubmitted(CakeEvent $event) {

		$Email = new CustomEmail();

		$Email->template('EvReview.review_submitted');
		$Email->to(Configure::read('SiteSetting.admin_email'));
		$Email->from(array(Configure::read('SiteSetting.admin_email') => Configure::read('SiteSetting.site_title')));
		$Email->subject(Configure::read('SiteSetting.site_title') . ' Review Submitted');
		$Email->viewVars(array(
			'id' => $event->data['id'],
			'data' => $event->data['data']
		));
		$Email->helpers(array(
				'Html'
		));
		$Email->send();

		return;

	}

}