<?php

class ReviewsController extends EvReviewAppController {


/**
 * Set admin form fields.
 * 
 * @return array
 */
	protected function _adminFormFields() {

		$Model = $this->{$this->modelClass};

		$fields = parent::_adminFormFields();

		// Hide model association fields.
		unset($fields["{$Model->alias}.model"]);
		unset($fields["{$Model->alias}.model_id"]);

		// Moved the reviewed_item_name field to the top of the form and make displayonly.
		unset($fields["{$Model->alias}.reviewed_item_name"]);
		$newFields["{$Model->alias}.reviewed_item_name"] = array(
			'displayonly' => 'displayonly',
			'type' => 'string',
			'label' => 'Review For'
		);
		$fields = $newFields + $fields;

		return $fields;

	}


/**
 * Defines the columns displayed in the admin_index results table
 * using a columns whitelist.
 * 
 * @return array
 */
	protected function _adminIndexColumns() {

		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$columns = parent::_adminIndexColumns();

		$columns["$modelAlias.reviewed_item_name"]['label'] = 'Review For';

		return $columns;

	}


/**
 * Defines a whitelist of columns to be displayed on the admin index.
 * @return array whitelisted columns
 */
	protected function _adminIndexColumnsWhitelist() {

		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$columns = parent::_adminIndexColumnsWhitelist();

		$columns[] = "$modelAlias.reviewed_item_name";

		return $columns;

	}


	protected function _adminFilterFields() {

		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$filters = parent::_adminFilterFields();

		$newFields = [];
		$newFields[$modelAlias . '.reviewed_item_name'] = array(
			'label' => 'Review For',
			'type' => 'string',
			'compare' => array($modelAlias . '.reviewed_item_name LIKE' => "%%%s%%")
		);

		$filters = ArrayUtil::addAfter($filters, $modelAlias . '.name', $newFields);

		return $filters;

	}

}