<?php

class ReviewsComponent extends Component {

	protected $_controller = null;


/**
 * Sets a reference to the calling controller from within the component.
 *
 * @see Component::initialize()
 */
	public function initialize(Controller $controller) {

		parent::initialize($controller);

		$this->_controller = $controller;

		$Model = $this->_controller->{$this->_controller->modelClass};

		$this->settings['model'] = empty($this->settings['model']) ? $Model->name : $this->settings['model'];
		$this->settings['plugin'] = empty($this->settings['plugin']) ? $Model->plugin : $this->settings['plugin'];

	}


/**
 * Returns paginated reviews for a model item.
 * 
 * @param integer $id model ID to retrieve reviews for
 * @param array $paginate additional paginate settings
 * @param array $conditions additional conditions
 * @return array
 */
	public function paginate($id, $paginate = [], $conditions = []) {

		$Model = $this->_controller->{$this->_controller->modelClass};

		$defaultPaginate = array(
			'order' => array(
				'Review.created' => 'DESC'
			)
		);

		$this->_controller->paginate = array_merge_recursive($defaultPaginate, $paginate);

		$defaultConditions = array(
			'Review.model_id' => $id,
			'Review.model' => $Model->alias,
			'Review.is_active' => true
		);

		$conditions = array_merge_recursive($defaultConditions, $conditions);

		return $this->_controller->paginate('EvReview.Review', $conditions);

	}


/**
 * Processes a review submission form.
 * 
 * @param integer $id model ID to save review against
 * @param mixed $redirectUrl (optional) routing array or URL to redirect to
 * @return void
 */
	public function processForm($id, $redirectUrl = null) {

		// Flag to check if we want to redirect after processing the form.
		$redirect = false;

		$Model = $this->_controller->{$this->_controller->modelClass};

		$data = $this->_controller->request->data;

		if ($this->_controller->request->is('post') && $this->_controller->checkProcessForm('EvReview.add_review')===true) {

			if (!empty($this->_controller->request->data['Review']['email_confirm'])) {

				// Spam detected. Pretend everythings gone OK.

				$this->_controller->Session->setFlash(
					__('Your review has been posted.'),
					'flash_success'
				);

				$redirect = true;

			} else {

				// Review looks genuine so proceed to saving it.

				$data['Review']['plugin'] = $this->settings['plugin'];
				$data['Review']['model'] = $this->settings['model'];
				$data['Review']['model_id'] = $id;

				if ($Model->Review->save($data)) {

					$this->_controller->Session->setFlash(
						__('Your review has been posted.'),
						'flash_success'
					);

					$redirect = true;

				} else {

					$this->_controller->Session->setFlash(
						__('There was a problem saving your review.'),
						'flash_fail'
					);

				}

			}

		}

		if ($redirect===true) {

			$this->_controller->redirect(
				$redirectUrl===null ? $this->_controller->referer() : $redirectUrl
			);

		}

		return;

	}

}