$(document).ready(function() {

	$('.cloneable').cloneable({
		delete_item_callback: function(item) {
			var fieldId = item.find('.field-id').val();

			if (parseInt(fieldId) > 0) {
				var toDelete = item.parents('.cloneable').find('.to-delete');
				toDelete.val(toDelete.val() + fieldId + ',');
			}
		}
	});

	$('.cloneable').on('keyup', '.related-search', function(e) {
		var searchString = $(this).val();
		var model = $(this).parents('.clone-row').find('.search-model').val();

		if (searchString.length > 3 && model.length > 0) {
			var itemList = $(this).parents('.clone-row').find('.item-list');
			itemList.empty();

			var options = '<option>Select Item</option>';

			$.ajax({
				'url': '/ajax/ev_related_items/related_items/search',
				'data': {
					'model': model,
					'search': searchString
				},
				'method': 'POST',
				'cache': false,
				success: function(data, textStatus, jqXHR) {
					// add all the options
					for (var i in data) {
						options += '<option value="' + i + '">' + data[i] + '</option>';
					}
				},
				complete: function(jqXHR, textStatus) {

					// add to drop down on complete
					itemList.html(options);
				}
			});
		}

	});
});