<?php

/**
 *
 */

class RelatableBehavior extends ModelBehavior {

	/**
	 * Default values for settings.
	 *
	 * - models: Defines the models the item can be related to
	 *
	 * @access private
	 * @var array
	 */
	private $defaults = array(
		'models' => array(),
	);

	/**
	 * Configuration method.
	 *
	 * @param object $Model Model object
	 * @param array $config Config array
	 * @access public
	 * @return boolean
	 */
	public function setup(Model $Model, $config = array()) {
		$this->settings[$Model->alias] = array_merge($this->defaults, $config);

		//On setup, add the relationships
		foreach($this->settings[$Model->alias]['models'] as $modelAlias => $modelSettings) {

			list($plugin, $modelName) = pluginSplit($modelAlias);

			$model =  "Related".Inflector::camelize($modelName);
			$Model->hasAndBelongsToMany[$model] = array(
				'className' => $modelAlias,
				'foreignKey' => 'model_id',
				'associationForeignKey' => 'related_model_id',
				'conditions' => array(
					'model' => $Model->name,
					'related_model' => $modelName
				),
				'with' => 'EvRelatedItems.RelatedItem',
				'dependent' => true,
				'cascade' => true, 
				'unique' => true
			);


		}

		$Model->hasMany['RelatedItem'] = array(
			'className' => 'EvRelatedItems.RelatedItem',
			'foreignKey' => 'model_id', 
			'cascade' => true, 
			'dependent' => true, 
			'conditions' => array(
				'model' => $Model->name, 
				'related_model' => $modelName
			)
		);

		return true;
	}


	public function containRelatedItems(Model $Model, $query = array(), $models = false) {

		//On setup, add the relationships
		foreach($this->settings[$Model->alias]['models'] as $modelAlias => $modelSettings) {

			list($plugin, $modelName) = pluginSplit($modelAlias);

			$model =  "Related".Inflector::camelize($modelName);

			if(isset($modelSettings['contain'])) {

				$query['contain'][$model] = $modelSettings['contain'];

			} else {

				$query['contain'][$model] = array();

			}

		}

		return $query; 

	}

}
