<?php

App::uses('Component', 'Controller');

class RelatedItemsComponent extends Component {
    
	public function processInputs($Model, $data, $currentModelId = null) {

		$models = $Model->actsAs['EvRelatedItems.Relatable']['models'];

		$fields = array();

		foreach($models as $model => $modelParams) {
			
			list($plugin, $relatedModel) = pluginSplit($model);

			$data = $this->processInput($data, $Model->alias, $relatedModel, $currentModelId); 

		}

		return $data;

	}

    public function processInput($data, $currentModelType, $relatedModelType, $currentModelId = null) {

    	//If there is some related items selected then process
    	if(is_array($data['Related'.$relatedModelType]['Related'.$relatedModelType])) {

		    foreach($data['Related'.$relatedModelType]['Related'.$relatedModelType] as $key=>$relatedModelId) {

				$data['RelatedItem'][] = array(
					'model' => $currentModelType, 
					'related_model' => $relatedModelType, 
					'related_model_id' => $relatedModelId
				);

			}

    	} elseif(is_numeric($data['Related'.$relatedModelType]['Related'.$relatedModelType])) {

    		$data['RelatedItem'][] = array(
				'model' => $currentModelType, 
				'related_model' => $relatedModelType, 
				'related_model_id' => $data['Related'.$relatedModelType]['Related'.$relatedModelType]
			);

    	}

		unset($data['Related'.$relatedModelType]);

		//This isn't a first save so we can remove previous
		if(!is_null($currentModelId)) {

			$RelatedItem = ClassRegistry::init('EvRelatedItems.RelatedItem');
			$RelatedItem->deleteAll(array(
					'model' => $currentModelType,
					'related_model' => $relatedModelType, 
					'model_id' => $currentModelId 
				)
			);

		}

		return $data;

	}

	public function generateFormFields($Model) {

		$models = $Model->actsAs['EvRelatedItems.Relatable']['models'];

		$fields = array();

		foreach($models as $model => $modelParams) {
			
			list($plugin, $modelName) = pluginSplit($model);

			$relatedModel = "Related".$modelName;

			unset($modelParams['contain']);	

			$fields["Related{$modelName}.Related{$modelName}"] = array_merge(array(
				'type' => 'select', 
				'multiple' => true, 
				'empty' => false,
				'label' => $modelName
			), $modelParams);

		}

		return $fields;

	}

}	