# EvRelatedItems

## Installation

Simply add EvRelatedItems to the `install.php` file within the Config directory and run `Console/cake installer core` once you have added all the other plugins you will need.

If this has already been run, simply run `Console/cake installer plugin EvRelatedItems`.

There is no installer for this plugin, only zuul... i mean migrations.

## How it works

This plugin works by defining in the config which models can be searched on and then attaching the RelatableBehavior onto the models that are to be the "Parent" models.

Using the `formInject` functionality, this behavior will then inject a form tab to the parent model which adds cloneable "Add New" rows. Within a new row, the model type can be selected and then searched upon. When searching, the results are then added to the item list drop down allow you to select the item.

The behavior then handles all of the saving.

From the frontend perspective, the behavior automatically creates the relationships based on the options defined in the config allow you to simply contain in the related data. As they are setup as basic relationships, the related items can then also contain any data they are related to.

## Setup

Once the installer has run, the config needs setting up to define which models can be linked. This is defined as an array in a `'Label' => 'PluginName.ModelName` format. These are the options that will be available in the "Type" dropdown within the Related Items tab.

	'RelatableOptions' => array(
		'Product' => 'EvShop.Product'
	)

Then for any model that wants to act as the parent for the related item simply attach the `RelatableBehavior` with `formInject` set to true.

Below is an example from Brighton Tools Product Model.

	if (CakePlugin::loaded('EvRelatedItems')) {
		$this->actsAs['EvRelatedItems.Relatable'] = array(
			'formInject' => true
		);
	}
	
## Usage

Once setup as above and related items have been added, within your `readForView()` or `find()` methods you can simply contain the related items. They become available at `RelatedLabel` where `Label`, is the `Label` as defined in the config file.

For the above example, related products they would be available at `RelatedProduct`.

	->readForView(
		69,
		[
			'contain' => [
				'RelatedProduct' => [
					'ListingImage',
					'Variant'
				]
			]
		]
	);
	
Further examples for the following config.

	'RelatableOptions' => array(
		'BlogPost' => 'EvBlogPost.BlogPost',
		'Team' => 'EvTeam.TeamMember',
		'Page' => 'EvCore.Page'
	)

	'contain' => [
		'RelatedBlogPost',
		'RelatedTeam',
		'RelatedPage'
	]

