<?php

App::uses('EvRelatedItemsAppController', 'EvRelatedItems.Controller');

class RelatedItemsController extends EvRelatedItemsAppController {

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow('ajax_search');
	}

	public function ajax_search() {
		if ($this->request->is('post') && ! empty($this->request->data['model']) && ! empty($this->request->data['search'])) {
			$Model = EvClassRegistry::init($this->request->data['model']);

			$results = $Model->find(
				'list',
				array(
					'conditions' => array(
						$Model->alias . '.' . $Model->displayField . ' LIKE' => '%' . $this->request->data['search'] . '%'
					),
					'callbacks' => false
				)
			);
		} else {
			$results = array(
				'This request must be a POST request and a model / search term must be set'
			);

			$this->response->statusCode(204);
		}

		$this->response->type('json');
		$this->response->disableCache();
		$this->response->body(
			json_encode($results)
		);

		return $this->response;
	}
}
