<?php if (Configure::read('EvRanges.allowMultipleRanges')): ?>
	<div class="form-group form-group--multicheck">
		<label for="ProductsRange" class="col-xs-12 col-sm-3 col-lg-2 control-label">Select Ranges</label>
		<div class="col-xs-12 col-sm-9 col-lg-10">
			<?php
				foreach ($ranges as $id => $range):
					$checked = false;

					if (isset($this->request->data['ProductsRange'][$id])):
						$checked = true;

						echo $this->Form->input('ProductsRange.' . $id . '.id', array(
							'type' => 'hidden',
							'value' => $this->request->data['ProductsRange'][$id]['id']
						));
					endif;

					$checkboxElement = $this->Form->checkbox(
						'ProductsRange.' . $id . '.range_id',
						array(
							'type' => 'checkbox',
							'value' => $id,
							'hiddenField' => false,
							'checked' => $checked
						)
					);

					echo $this->Form->label(
						'ProductsRange.' . $id . '.range_id',
						$checkboxElement . ' ' . $range,
						['class' => 'radio col-xs-12 col-sm-6']
					);
				endforeach;
			?>
		</div>
	</div>
<?php else: ?>
	<?php
		$existingRange = null;
		if (!empty($this->request->data['ProductsRange']['id'])):
			$existingRange = [
				'id' => $this->request->data['ProductsRange']['id'],
			];
		elseif (!empty($this->request->data['ProductsRange'])):
			$existingRange = reset($this->request->data['ProductsRange']);
		endif;

		if (!empty($existingRange) && isset($existingRange['id'])):
			echo $this->Form->addField(
				'ProductsRange.id',
				[
					'type' => 'hidden',
					'value' => $existingRange['id']
				]
			);
		endif;

		$selectedRange = null;
		if (!empty($this->request->data['ProductsRange']['range_id'])):
			$selectedRange = $this->request->data['ProductsRange']['range_id'];
		elseif (!empty($existingRange)):
			$selectedRange = $existingRange['range_id'];
		endif;

		echo $this->Form->addField(
			'ProductsRange.range_id',
			[
				'type' => 'select',
				'options' => $ranges,
				'selected' => $selectedRange,
			]
		);
	?>
<?php endif; ?>
