# EvRanges

## Requirements
This plugin is an extension to the EvShop plugin. Without EvShop this plugin won't function correctly.

## Installation
Simply add EvRanges to the `install.php` file within the Config directory and run `Console/cake installer core` once you have added all the other plugins you will need.

If this has already been run, simply run `Console/cake installer plugin EvRanges`.

The installer will automatically setup the database tables.

## CMS Menu
To access the ranges page in the CMS, you will need to add the menu item. Add a menu item anywhere you would like (usually under catalog) with the url `ev_ranges/ranges`.

## Creating And Assigning A Range
Creating a range is simple and follows the same process as creating a category. When creating/editting a range in the CMS there is a tab called Products. This tab displays all the products currently on the site in a list with checkboxes next to each of them. Selecting the checkboxes and saving the range will associate those products with the current range.

There is also a behavior that adds the ranges tab to products.

	public $actsAs = array(
		'EvRanges.Ranges' => array(
			'formInject' => true,
		),
	);

To make the form function you will also need to override the product model and add:

	'ProductsRange' => array(
		'className' => 'EvRanges.ProductsRange',
	)

to the `hasMany` array. You will also need to add:

	$query['contain']['ProductsRange'] = 'Range';

to your product `readForEdit` model so that the ranges are contained for the form.

## Mutiple Ranges
Multiple ranges are supported by default. If you wish to make it so that only a single range can be associated with a product then use the config setting `allowMultipleRanges` and set it to false. This will change the injected form so instead of a multi-checkbox there is a select box so a single range can be selected.
