<?php

App::uses('EvRangesAppModel', 'EvRanges.Model');

class Range extends EvRangesAppModel {

	public $actsAs = array(
		'Routable.Routable' => array(
			'config' => 'EvRanges',
			'alias' => 'range/:displayField/*'
		),
		'MetaData.Meta',
		'EvTemplates.Template' => array(
			'formInject' => true,
			'restrictTo' => 'Range'
		)
	);

	/**
	 * Display field
	 *
	 * @var string
	 */
	public $displayField = 'name';

	/**
	 * Validation rules
	 *
	 * @var array
	 */
	public $validate = array(
		'name' => array(
			'notEmpty' => array(
				'rule' => array('notBlank'),
				'message' => 'A range name must be entered.'
			),
		),
	);

	/**
	 * hasMany relationships
	 */
	public $hasMany = array(
		'ProductsRange' => array(
			'className' => 'EvRanges.ProductsRange',
		)
	);

	public $imageSlots = array(
		'rangeLogo' => array(
			'slots' => 1,
			'fields' => false,
		),
	);

	public function readForEdit($id, $params = array()) {
		$params['contain'][] = 'ProductsRange';

		return parent::readForEdit($id, $params);
	}

	public function beforeValidate($options = array()) {
		if (!empty($this->data['ProductsRange'])) {
			//Remove unselected products
			foreach ($this->data['ProductsRange'] as $index => $productsRange) {
				if ($productsRange['product_id'] == 0) {
					unset($this->data['ProductsRange'][$index]);
				}
			}
		}

		return true;
	}

/**
 * check the selected categories to see which ones we need to unlink
 *
 * @param 	array 	The array of selected ranges passed by reference
 * @return 	array 	Array fo linker table rows to deleted
 */
	public function processDeletedRanges(&$data) {
		$toDelete = array();

		if (!empty($data)) {
			foreach ($data as $rangeId => $range) {
				if (isset($range['id']) && ! isset($range['range_id'])) {

					$toDelete[] = $range['id']; // id of the linker table row
					unset($data[$rangeId]);
				}
			}
		}

		return $toDelete;
	}

/**
 * Check the single range and add/update/delete the correct ranges
 * @param array &$data The selected range.
 * @return array        The product ranges to delete.
 */
	public function processRange(&$data) {
		$toDelete = [];

		if (!empty($data['range_id'])) {
			// range selected
			$data[$data['range_id']] = [
				'range_id' => $data['range_id']
			];

			if (!empty($data['id'])) {
				$data[$data['range_id']]['id'] = $data['id'];
			}
		} else {
			//range not selected, if a previous range was selected then delete it
			if (!empty($data['id'])) {
				$toDelete[] = $data['id'];
			}
		}

		unset($data['range_id']);
		if (!empty($data['id'])) {
			unset($data['id']);
		}

		return $toDelete;
	}
}
