<?php

App::uses('AppBehavior', 'Model/Behavior');

class RangesBehavior extends AppBehavior {

/**
 * Setup this behavior with the specified configuration settings.
 *
 * @param Model $model Model using this behavior
 * @param array $config Configuration settings for $model
 * @return void
 */
	public function setup(Model $Model, $config = array()) {
		parent::setup($Model, $config);
	}

/**
 * afterFind
 *
 * @param Model $Model
 * @param array $results Array of results
 * @param $primary
 * @return array $results.
 */
	public function afterFind(Model $Model, $results, $primary = false) {
		foreach ($results as $resultIndex => $result) {
			if (!empty($results[$resultIndex]['ProductsRange'])) {
				$results[$resultIndex]['ProductsRange'] = Hash::combine($result['ProductsRange'], '{n}.range_id', '{n}');
			}
		}

		return $results;
	}

/**
 * before we save anything process the options into variants
 * also process the category array
 * also process the variant images
 */
	public function beforeBeforeSave(Model $Model, $data, $options) {
		if (Configure::read('EvRanges.allowMultipleRanges')) {
			// Deal with multiple ranges
			$Range = EvClassRegistry::init('EvRanges.Range');
			$this->rangesToDelete = $Range->processDeletedRanges($data['ProductsRange']);
		} else {
			// Deal with single ranges
			$Range = EvClassRegistry::init('EvRanges.Range');
			$this->rangesToDelete = $Range->processRange($data['ProductsRange']);
		}

		return $data;
	}

/**
 * afterSave
 *
 * @param Model $Model
 * @param array $created Whether the record has been created or updated
 * @param $options
 */
	public function afterSave(Model $Model, $created, $options = []) {
		if (! empty($this->rangesToDelete)) {
			$ProductsRange = EvClassRegistry::init('EvRanges.ProductsRange');

			$ProductsRange->deleteAll(
				array(
					'ProductsRange.id' => $this->rangesToDelete
				)
			);
		}
	}
}
