<?php

App::uses('CakeEventListener', 'Event');
App::uses('DiscountLib', 'EvDiscount.Lib');

class EvRangesCheckForDiscountRestrictionsListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvBasket.Component.BasketItem.CheckDiscountRestrictions' => 'checkForDiscountRestrictions',
		);
	}

/**
 * Rebuild discount due to basket amends
 *
 * @param CakeEvent
 * @return array Empty array if no restriction is used. `discountValue` added as true/false if restriction is met.
 */
	public function checkForDiscountRestrictions(CakeEvent $Event) {
		if (!empty($Event->result)) {
			//Default to past restriction result
			$result = $Event->result;
		} else {
			// Default to invalidating the discount
			$result = [];
		}

		if (
			empty($Event->data['discount']['code_restrictions']) ||
			empty($Event->data['basket_item'])
		) {
			return $result;
		}

		// Restrictions were found. Check to see if they are for the ranges
		$basketItem = $Event->data['basket_item'];
		$discount = $Event->data['discount'];

		// Get the product id for basket item
		if ($basketItem['model'] == 'EvShop.Variant') {
			if (isset($basketItem['Variant']['Product'])) {
				$productId = $basketItem['Variant']['Product']['id'];
			}
		} elseif ($basketItem['model'] == 'EvShop.Product') {
			$productId = $basketItem['model_id'];
		}

		if (empty($productId)) {
			return $result;
		}

		// We've now got a list of product ids in the basket. Now we need to go through each code restriction
		// and work out if it applies to any of the products in the basket.
		foreach ($discount['code_restrictions'] as $restriction) {
			if ($restriction['model'] == 'EvRanges.Range') {

				$ProductsRange = EvClassRegistry::init('EvRanges.ProductsRange');
				$matchingProductsRange = $ProductsRange->find(
					'all',
					[
						'fields' => [
							'ProductsRange.id'
						],
						'conditions' => [
							'ProductsRange.product_id' => $productId,
							'ProductsRange.range_id' => $restriction['model_id']
						]
					]
				);

				// If any categories exist then this product should be discount
				if (!empty($matchingProductsRange)) {
					$result = array(
						'discountValue' => true
					);
				} else {
					$result = array(
						'discountValue' => false
					);
				}
			}
		}

		return $result;
	}
}
