<?php

App::uses('EvRangesAppController', 'EvRanges.Controller');

class RangesController extends EvRangesAppController {

	/**
	 * redefine to allow the index / view page through the auth component!
	 */
	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array('index', 'view'));
	}

	/**
	 * process the param array for the ranges
	 *
	 * @return 	array 		   	  Standard parameter array to pass to find
	 */
	protected function _processRangeParams() {
		return array();
	}

	/**
	 * process the param array for products
	 *
	 * @param 	array 	$Range The current range
	 * @return 	array 		   	  Standard parameter array to pass to find
	 */
	protected function _processProductParams($Range) {
		return array();
	}

	/**
	 * Display all the ranges on the site
	 */
	public function index() {
		$this->view = 'EvRanges./Fallbacks/Ranges/index';
		$pageId = Configure::read('EvRanges.pageIds.range');

		// check if we have a specific content page set
		// if so - set the template
		if (! empty($pageId)) {
			$pageData = $this->assignPage($pageId);

			if (! empty($pageData)) {
				$this->view = $this->Tpl->getTemplate($pageData, 'Page');
			}
		}

		$this->set(
			'listing',
			$this->Ranges->listing(
				$this->_processRangeParams()
			)
		);

		$this->Breadcrumb->addCrumb(__('All Ranges'));
	}

	/**
	 * range view details page with product listing
	 *
	 * @param 	int 	Brand ID
	 */
	public function view($id) {
		$Model = $this->{$this->modelClass};
		$this->view = 'EvRanges./Fallbacks/Ranges/view';

		$data = $Model->readForView($id);
		if (empty($data)) {
			throw new NotFoundException();
		}

		$this->set('data', $data);
		$this->Meta->set($data);

		if (! empty($data[$Model->alias]['template_id'])) {
			$this->view = $this->Tpl->getTemplate($data);
		}

		// get any products
		$this->set(
			array(
				'productListing' => $this->Ranges->listingByRange(
					$id,
					$this->_processProductParams($data)
				)
			)
		);
	}

	/**
	 * Add or edit a range.
	 *
	 * @param  integer $id User ID
	 * @return void
	 */
	public function admin_edit($id = null) {
		$Model = $this->{$this->modelClass};

		// call the parent admin_edit to do the add / edit
		parent::admin_edit($id);

		$this->set('availableProducts', $this->_getAvailableProducts($id));
		$this->set('currentProducts', $this->_getCurrentProducts($id));

		$this->view = 'EvRanges.Ranges/admin_edit';
	}

	protected function _adminFormFields() {
		$Model = $this->{$this->modelClass};
		$alias = $Model->alias;

		$fields = parent::_adminFormFields();

		if (isset($fields[$alias . '.body'])) {
			$fields[$alias . '.body']['type'] = 'html';
		}

		return $fields;
	}

	protected function _getAvailableProducts($rangeId) {
		$Product = EvClassRegistry::init('EvShop.Product');
		return $Product->find(
			'list',
			[
				'conditions' => [
					'Product.is_active'
				]
			]
		);
	}

	protected function _getCurrentProducts($rangeId) {
		$ProductsRange = EvClassRegistry::init('EvRanges.ProductsRange');
		return $ProductsRange->find(
			'all',
			[
				'fields' => [
					'Product.id',
					'Product.name'
				],
				'joins' => [
					[
						'table' => 'ev_shop_products',
						'alias' => 'Product',
						'conditions' => [
							'Product.id = ProductsRange.product_id'
						]
					]
				],
				'conditions' => [
					'ProductsRange.range_id' => $rangeId
				]
			]
		);
	}
}
