<?php

App::uses('AppComponent', 'Controller/Component');

class RangesComponent extends AppComponent {

	/**
	 * Get a listing of ranges
	 *
	 * @param 	array 	query / paginate params
	 * @param 	bool 	Paginate results or not?
	 * @return 	array 	Array of results
	 */
	public function listing($params = array(), $paginate = true) {
		$params = Hash::merge(
			$this->_getDefaultParamsForListing(),
			$params
		);

		$Range = EvClassRegistry::init('EvRanges.Range');

		if ($paginate && ! empty($this->_controller)) {
			$this->_controller->Paginator->settings = $params;
			return $this->_controller->Paginator->paginate(
				$Range
			);
		} else {
			return $Range->find('all', $params);
		}
	}

	/**
	 * Get a product listing by range
	 * @param  int $rangeId   The id of range to query by
	 * @param  array  $params    any additional parameters to pass to the query
	 * @param  bool   $paginate  Pagiante the results or not
	 * @param  array $orderData An array of additional data to pass to the listing so conditional parameters can be added
	 * @return array           The listing results
	 */
	public function listingByRange($rangeId, $params = array(), $paginate = true, $orderData = null) {
		$params['joins'][] = [
			'table' => 'ev_ranges_products_ranges',
			'alias' => 'ProductsRange',
			'conditions' => [
				'ProductsRange.product_id = Product.id'
			]
		];

		$params['conditions']['ProductsRange.range_id'] = $rangeId;

		return $this->_controller->Products->listing($params, $paginate, $orderData);
	}

	/**
	 * Get the parameters for a default range listing.
	 * @return array default parameters for a cake pagiante or find query.
	 */
	protected function _getDefaultParamsForListing() {
		return array(
			'conditions' => array(
				'Range.is_active' => 1
			),
			'order' => 'Range.name ASC, Range.sequence ASC',
			'contain' => array(
				'LogoImage'
			)
		);
	}

/**
 * run the form injection
 * For custom fields this add type / validation arrays to the template for fields
 *
 * @param   array       Data from $this->request->data
 * @param   object      Model Object for the primary model we are dealing with
 * @param   int|null    The ID if on edit or null of add
 */
	public function injectAdminForm($data, $Model, $id) {
		$this->_controller->set('ranges', EvClassRegistry::init('EvRanges.Range')->find('list', ['order' => 'Range.name ASC']));
	}
}
