<?php

App::uses('AppHelper', 'View/Helper');

class PropertiesHelper extends AppHelper {

	public $helpers = [
		'Form'
	];

/**
 * Generate a group of dropdowns that provide minimum and maximum values. Field attributes are standard field attributes
 * that are applied to the group as a whole. Attributes for the individual minimum and maximum fields can be independently
 * specified or supplied through the field attributes using "minAttributes" and "maxAttributes" keys. The a minimum and
 * maximum attributes are merged with the passed attributes taking priority.
 * @param  string $fieldName       The name of the field
 * @param  array  $fieldAttributes The attributes to apply to the field group
 * @param  array  $minAttributes   The attributes to apply to the minimum field
 * @param  array  $maxAttributes   The attributes to apply to the maximum field
 * @return string                  The html string for the minMax input
 */
	public function minMaxInput($fieldName, $fieldAttributes, $minAttributes = [], $maxAttributes = []) {
		$minFieldAttributes = [];
		if (isset($fieldAttributes['minAttributes'])) {
			$minFieldAttributes = $fieldAttributes['minAttributes'];
			unset($fieldAttributes['minAttributes']);
		}

		$maxFieldAttributes = [];
		if (isset($fieldAttributes['maxAttributes'])) {
			$maxFieldAttributes = $fieldAttributes['maxAttributes'];
			unset($fieldAttributes['maxAttributes']);
		}

		$minMaxField = '<div class="min-max-field ' . (!empty($fieldAttributes['div']) ? $fieldAttributes['div'] : '') . '">';

		if (!empty($fieldAttributes['label'])) {
			if (is_array($fieldAttributes['label'])) {
				if (!empty($fieldAttributes['label']['class'])) {
					$minMaxField .= '<div class="' . $fieldAttributes['label']['class'] . '">';
				}

				if (!empty($fieldAttributes['label']['text'])) {
					$minMaxField .= '<label>' . $fieldAttributes['label']['text'] . '</label>';
				}

				if (!empty($fieldAttributes['label']['class'])) {
					$minMaxField .= '</div>';
				}

			} else {
				$minMaxField .= '<label>' . $fieldAttributes['label'] . '</label>';
			}
		}

		$minFieldAttributes = Hash::merge(
			$minFieldAttributes,
			$minAttributes
		);
		$minMaxField .= $this->Form->input(
			$fieldName . '-Min',
			$minFieldAttributes
		);

		$maxFieldAttributes = Hash::merge(
			$maxFieldAttributes,
			$maxAttributes
		);
		$minMaxField .= $this->Form->input(
			$fieldName . '-Max',
			$maxFieldAttributes
		);

		$minMaxField .= '</div>';

		return $minMaxField;
	}
}
