<?php

App::uses('EvPropertyAppModel', 'EvProperty.Model');

class PropertyType extends EvPropertyAppModel {

	public $displayField = 'name';

	public $hasMany = [
		'ResidentialProperty' => [
			'className' => 'EvProperty.ResidentialProperty',
			'dependent' => true
		]
	];

/**
 * Get all active property types for a department for a dropdown
 * @param  string $department The department to get the property types for
 * @return array              The property types
 */
	public function getTypesForDropdown($department) {
		return $this->find(
			'list',
			[
				'conditions' => [
					'PropertyType.department' => $department,
					'PropertyType.is_active' => true
				]
			]
		);
	}

}
