<?php

App::uses('EvPropertyAppController', 'EvProperty.Controller');

class ResidentialPropertiesController extends EvPropertyAppController {

	public $helpers = [
		'EvProperty.Properties'
	];

	public $components = [
		'EvProperty.Properties'
	];

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(
			[
				'index',
				'propertiesForSale',
				'propertiesToLet',
				'view'
			]
		);

		//Check if any filters have been applied and if so redirect them to the same page with the filters applied
		if ($this->request->is('post')) {
			if (!empty($this->request->data['filter'])) {
				$this->redirect($this->Properties->getRedirectFromFilters($this->request));
			}
		}
	}

/**
 * Display all the properties on the site
 */
	public function index() {
		$Model = $this->{$this->modelClass};
		$alias = $Model->alias;

		$pageId = Configure::read('EvProperty.pageIds.index');
		if (!empty($pageId)) {
			$this->assignPage($pageId);
		}

		$this->set('properties', $this->ResidentialProperty->readForIndex());

		$this->view = 'EvProperty.Properties/index';
	}

/**
 * Display all the properties on the site that are in the Sales department
 */
	public function propertiesForSale() {
		$Model = $this->{$this->modelClass};
		$alias = $Model->alias;

		$pageId = Configure::read('EvProperty.pageIds.propertiesForSale');
		if (!empty($pageId)) {
			$this->assignPage($pageId);
		}

		if (!empty($this->request->params['named'])) {
			$this->request->data['filter'] = $this->request->params['named'];
		}

		$query = $this->Properties->getQueryFromFilters($this->request->params['named'], $alias);

		$this->set('properties', $this->Properties->readPropertiesForSale($query));

		$this->set('propertyFilters', $this->ResidentialProperty->getFilters('Sales', 'listing'));

		$this->view = 'EvProperty.Properties/index';
	}

/**
 * Display all the properties on the site that are in the Lettings department
 */
	public function propertiesToLet() {
		$Model = $this->{$this->modelClass};
		$alias = $Model->alias;

		$pageId = Configure::read('EvProperty.pageIds.propertiesToLet');
		if (!empty($pageId)) {
			$this->assignPage($pageId);
		}

		if (!empty($this->request->params['named'])) {
			$this->request->data['filter'] = $this->request->params['named'];
		}

		$query = $this->Properties->getQueryFromFilters($this->request->params['named'], $alias);

		$this->set('properties', $this->Properties->readPropertiesToLet($query));

		$this->set('propertyFilters', $this->ResidentialProperty->getFilters('Lettings', 'listing'));

		$this->view = 'EvProperty.Properties/index';
	}

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		//	Changed it to text in a migration to increase the character limit as 360 urls are bigger than 255
		//	characters. We don't want it to be a rich text area as this'll mess things up.
		$fields['ResidentialProperty.streetview_override_url']['type'] = 'string';

		return $fields;
	}

/**
 * View a specific residential property
 * @param  int $id The id of the property to view
 */
	public function view($id) {
		$Model = $this->{$this->modelClass};
		$alias = $Model->alias;

		$data = $Model->readForView($id);
		$this->Meta->set($data);

		$this->set('data', $data);

		$this->view = 'EvProperty.Properties/view';
	}
}
