<?php

App::uses('AppComponent', 'Controller/Component');

class PropertiesComponent extends AppComponent {

/**
 * Get a listing of properties that are currently available for sale
 * @param  array   $params   Extra parameters to pass to the default listing query.
 * @param  boolean $paginate Whether to paginate the query results or not.
 * @return array             The properties found matching the query.
 */
	public function readPropertiesForSale($params = [], $paginate = true) {
		$ResidentialProperty = EvClassRegistry::init('EvProperty.ResidentialProperty');

		$propertyParams = Hash::merge($ResidentialProperty->readForSaleParams(), $params);

		return $this->_readProperties($ResidentialProperty, $propertyParams, $paginate);
	}

/**
 * Get a listing of properties that are currently avaiable to rent.
 * @param  array   $params   Extra parameters to pass to the default listing query.
 * @param  boolean $paginate Whether to paginate the query results or not.
 * @return array             The properties found matching the query.
 */
	public function readPropertiesToLet($params = [], $paginate = true) {
		$ResidentialProperty = EvClassRegistry::init('EvProperty.ResidentialProperty');

		$propertyParams = Hash::merge($ResidentialProperty->readToLetParams(), $params);

		return $this->_readProperties($ResidentialProperty, $propertyParams, $paginate);
	}

/**
 * Get the filter parameters from a request and generate a url.
 * @param  obj    $request The request of the current controller
 * @return string          The url to direct to
 */
	public function getRedirectFromFilters($request = []) {
		$newRoute = $request->params;

		$changedFilter = false;

		//Take out the passed in filter data and assign it to the new route
		if (! empty($request->data['filter'])) {
			foreach ($request->data['filter'] as $filterField => $filterValue) {
				if (!empty($filterValue)) {
					if (in_array($filterField, array_keys($newRoute['named']))) {
						$newRoute[$filterField] = $filterValue;
						unset($newRoute['named'][$filterField]);
					} else {
						$newRoute[$filterField] = $filterValue;
					}
					$changedFilter = true;
				} else {
					if (in_array($filterField, array_keys($newRoute['named']))) {
						unset($newRoute['named'][$filterField]);
						$changedFilter = true;
					}
				}
			}
		}

		//Take named params out
		foreach ($newRoute['named'] as $namedField => $namedValue) {
			$newRoute[$namedField] = $namedValue;
		}

		unset($newRoute['named']);

		if ($changedFilter && isset($newRoute['page'])) {
			unset($newRoute['page']);
		}

		return Router::url($newRoute);
	}

/**
 * Create an array of extra parameters from the provided filter array to be used in queries on the listing page.
 * @param  array  $filters    The filter criteria to create query parameters from.
 * @param  string $modelAlias The alias of the model currently querying so that fields are queried correctly.
 * @return array              The array of parameters to add to queries.
 */
	public function getQueryFromFilters($filters, $modelAlias) {
		$query = [];

		if (!empty($filters)) {
			foreach ($filters as $filterField => $filterValue) {
				if ($filterField == 'page') {
					continue;
				}

				if (strpos($filterField, '-Min') !== false || strpos($filterField, '-Max') !== false) {
					list($fieldName, $minOrMAx) = explode('-', $filterField);
					if ($minOrMAx == 'Min') {
						$query['conditions'][] = $modelAlias . '.' . $fieldName . ' >= ' . $filterValue;
					} else {
						$query['conditions'][] = $modelAlias . '.' . $fieldName . ' <= ' . $filterValue;
					}
				} else {
					$query['conditions'][$modelAlias . '.' . $filterField] = $filterValue;
				}
			}
		}

		return $query;
	}

/**
 * Get a listing of the properties that currently exist.
 * @param  obj    $Model    The model to get a listing for.
 * @param  array  $params   The parameters to pass to the query.
 * @param  bool   $paginate Whether to paginate or not
 * @return array            The results of the listing.
 */
	protected function _readProperties($Model, $params, $paginate) {
		if ($paginate) {
			$this->_controller->Paginator->settings = $params;
			return $this->_controller->Paginator->paginate(
				$Model
			);
		} else {
			return $Model->find('all', $params);
		}
	}
}
