<?php

App::uses('PluginInstallShell', 'shells');

class EvPropertyInstallShell extends PluginInstallShell {

	public $uses = [
		'EvSiteSettings.SiteSetting',
		'EvSiteSettings.SiteSettingCategory',
	];

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run() {
		parent::run();

		//Add the filter ranges to site settings so that they can be editted from the CMS.
		$Category = $this->SiteSettingCategory->save(
			array(
				'SiteSettingCategory' => array(
					'name' => 'Properties',
					'array_slug' => 'ev_property',
					'sequence' => 0,
					'prevent_edit' => 0
				)
			)
		);

		$this->SiteSetting->saveMany(
			array(
				array(
					'name' => 'Search - Price Minimums',
					'array_slug' => 'search_price_minimums',
					'value' => '50000,100000,150000,200000',
					'type' => 'string',
					'sequence' => 10,
					'site_setting_category_id' => $this->SiteSettingCategory->id,
					'prevent_edit' => 0
				),
				array(
					'name' => 'Search - Price Maximums',
					'array_slug' => 'search_price_maximums',
					'value' => '150000,200000,250000,300000',
					'type' => 'string',
					'sequence' => 20,
					'site_setting_category_id' => $this->SiteSettingCategory->id,
					'prevent_edit' => 0
				),
				array(
					'name' => 'Search - Rent Minimums',
					'array_slug' => 'search_rent_maximums',
					'value' => '500,1000,2000,3000',
					'type' => 'string',
					'sequence' => 20,
					'site_setting_category_id' => $this->SiteSettingCategory->id,
					'prevent_edit' => 0
				),
				array(
					'name' => 'Search - Rent Maximums',
					'array_slug' => 'search_rent_maximums',
					'value' => '1000,2000,3000,5000',
					'type' => 'string',
					'sequence' => 20,
					'site_setting_category_id' => $this->SiteSettingCategory->id,
					'prevent_edit' => 0
				),
				array(
					'name' => 'Search - Bedroom Minimums',
					'array_slug' => 'search_bedroom_minimums',
					'value' => '1,2,3,4,5',
					'type' => 'string',
					'sequence' => 50,
					'site_setting_category_id' => $this->SiteSettingCategory->id,
					'prevent_edit' => 0
				),
				array(
					'name' => 'Search - Bedroom Maximums',
					'array_slug' => 'search_bedroom_maximums',
					'value' => '1,2,3,4,5',
					'type' => 'string',
					'sequence' => 60,
					'site_setting_category_id' => $this->SiteSettingCategory->id,
					'prevent_edit' => 0
				),
			)
		);
	}
}
