<?php

$config = array(
	'EvProperty' => array(
		'route' => [
			'ResidentialProperty' => [
				'controller' => 'ev_property_residential_properties', // defined as plugin dot notation as plugin var is used for model references
				'action' => 'view',
				'plugin' => false, // used for model references
			]
		],

		'pageIds' => [
			'index' => null,
			'propertiesForSale' => 14,
			'propertiesToLet' => 15,
		],

		'filters' => [
			'listing' => [
				'location' => [
					'placeholder' => '(eg. Crookes or S10)',
				],
				'property_type_id' => [
					'empty' => 'Property Type',
					'wrap_input' => 'select col-xs-12',
				],
				'price' => [
					'minAttributes' => [
						'label' => [
							'text' => 'Price min',
							'class' => 'sr-only'
						],
						'empty' => 'No Min',
						'wrapInput' => 'select',
						'div' => 'col-xs-12 col-sm-6',
					],
					'maxAttributes' => [
						'label' => [
							'text' => 'Price max',
							'class' => 'sr-only'
						],
						'empty' => 'No Max',
						'wrapInput' => 'select',
						'div' => 'col-xs-12 col-sm-6',
					],
					'div' => 'form-group',
					'label' => [
						'text' => 'Price',
						'class' => 'col-xs-12',
					],
				],
				'rent' => [
					'minAttributes' => [
						'label' => [
							'text' => 'Price min',
							'class' => 'sr-only'
						],
						'empty' => 'No Min',
						'wrapInput' => 'select',
						'div' => 'col-xs-12 col-sm-6',
					],
					'maxAttributes' => [
						'label' => [
							'text' => 'Price max',
							'class' => 'sr-only'
						],
						'empty' => 'No Max',
						'wrapInput' => 'select',
						'div' => 'col-xs-12 col-sm-6',
					],
					'div' => 'form-group',
					'label' => [
						'text' => 'Price',
						'class' => 'col-xs-12',
					],
				],
				'bedrooms' => [
					'minAttributes' => [
						'label' => [
							'text' => 'Bedroom min',
							'class' => 'sr-only'
						],
						'empty' => 'No Min',
						'wrapInput' => 'select',
						'div' => 'col-xs-12 col-sm-6',
					],
					'maxAttributes' => [
						'label' => [
							'text' => 'Bedroom max',
							'class' => 'sr-only'
						],
						'empty' => 'No Max',
						'wrapInput' => 'select',
						'div' => 'col-xs-12 col-sm-6',
					],
					'div' => 'form-group',
					'label' => [
						'text' => 'Bedrooms',
						'class' => 'col-xs-12',
					],
				],
				'include_sstc_properties' => [
					'div' => 'form-group',
					'wrap_input' => 'checkbox',
					'class' => 'col-xs-12',
					'label' => [
						'text' => 'Include SSTC Properties'
					]
				],
				'include_recently_let' => [
					'div' => 'form-group',
					'wrap_input' => 'checkbox',
					'class' => 'col-xs-12'
				],
			],
		],
	)
);
