<?php

App::uses('AppHelper', 'View/Helper');

class PromotionsHelper extends AppHelper {

	public $helpers = ['Basket', 'Currencies'];

/**
 * @param $BasketItem
 *
 * @return string
 */
	public function getItemTotal($BasketItem) {
		$return = '';
		if (!empty($BasketItem['is_promotional'])) {
			if ($BasketItem['quantity'] == 1) {
				$return .= 'Free';
			} else {
				$return .= ($BasketItem['quantity'] - 1) . ' x ' . $this->Currencies->currency($this->Basket->displayBasketItemUnitPrice($BasketItem));
				$return .= '<br>1 x Free';
			}
		} else {
			$return .= $this->Currencies->currency($this->Basket->displayBasketItemUnitPrice($BasketItem));
		}

		return $return;
	}

/**
 * @param $BasketItem
 * @param bool $omitOrderVat
 *
 * @return mixed
 */
	public function getRowTotal($BasketItem, $omitOrderVat = false) {
		if (!empty($omitOrderVat)) {
			// show row total excluding VAT
			$unitPrice = $BasketItem['unit_price'];
			$rowTotal = $BasketItem['row_total'];
		} else {
			// show row total including VAT
			$unitPrice = $BasketItem['unit_price_incTax'];
			$rowTotal = $BasketItem['row_total_incTax'];
		}

		$return = $this->Currencies->currency($rowTotal);

		if (!empty($BasketItem['is_promotional'])) {
			$return .= '<br><span class="listing__subheader">(' . $this->Currencies->currency($unitPrice) . ')</span>';
		}

		return $return;
	}
}