<?php

App::uses('DiscountCode', 'EvDiscount.Model');
App::uses('ProductCacheLib', 'EvPromotion.Lib');

class Promotion extends DiscountCode {

	public $tablePrefix = "ev_promotion_";

	public function __construct($id = false, $table = null, $ds = null) {
		$route = Configure::read('EvPromotion.actualRoute');
		if (!empty($route)) {
			$this->actsAs['Routable.Routable'] = [
				'actual' => $route,
				'alias' => ':controller/:displayField',
			];
		}

		// No code to validate
		parent::__construct($id, $table, $ds);
		unset( $this->validate['code'] );
		unset( $this->validate['maximum_uses'] );
	}

	public $hasMany = array(
		'CodeRestriction' => array(
			'className' => 'EvDiscount.CodeRestriction',
			'foreignKey' => 'discount_model_id',
			'conditions' => [
				'discount_model' => 'Promotion'
			]
		)
	);

/**
 * Override afterSave to add in clearing of the product caches
 *
 * @param bool $created True if this save created a new record
 * @param array $options Options passed from Model::save().
 * @return void
 */
	public function afterSave($created, $options = array()) {
		parent::afterSave($created, $options);

		$ProductCacheLib = new ProductCacheLib();
		$ProductCacheLib->flush(['id' => $this->data['Promotion']['id']]);
	}

/**
 * Find all active promotions
 */
	public function findAllActive() {
		return $this->find('all', [
			'conditions' => [
				'or' => [
					'Promotion.start_date IS NULL AND Promotion.end_date IS NULL',
					'Promotion.start_date IS NULL AND Promotion.end_date IS NOT NULL AND Promotion.end_date > NOW()',
					'Promotion.end_date IS NULL AND Promotion.start_date IS NOT NULL AND Promotion.start_date <= NOW()',
					'Promotion.start_date IS NOT NULL AND Promotion.end_date IS NOT NULL AND NOW() BETWEEN Promotion.start_date AND Promotion.end_date',
				],
				'Promotion.is_active' => 1,
				'Promotion.currency_id' => CakeSession::read('EvCurrency.currencyId', null)
			],
			'contain' => [
				'DiscountType',
				'CodeRestriction'
			]
		]);
	}

/**
 * Find an active promotion
 * @param array|int $id Can be a single integer id or an array of ids
 */
	public function findActive($id, $queryOptions = []) {
		return $this->find('all', Hash::merge([
			'conditions' => [
				'or' => [
					'Promotion.start_date IS NULL AND Promotion.end_date IS NULL',
					'Promotion.start_date IS NULL AND Promotion.end_date IS NOT NULL AND Promotion.end_date > NOW()',
					'Promotion.end_date IS NULL AND Promotion.start_date IS NOT NULL AND Promotion.start_date <= NOW()',
					'Promotion.start_date IS NOT NULL AND Promotion.end_date IS NOT NULL AND NOW() BETWEEN Promotion.start_date AND Promotion.end_date',
				],
				'Promotion.is_active' => 1,
				'Promotion.currency_id' => CakeSession::read('EvCurrency.currencyId', null),
				'Promotion.id' => $id
			]
		], $queryOptions));
	}

}


