<?php

App::uses('CakeTime', 'Utility');

/**
 * Static lib to share code between helper and components
 */
class PromotionLib {

/**
 * Loops around the basket items and flags any that are present in the basket
 * data array and tagged as a promotional item
 *
 * @param array $basket The full basket array
 * @return array A modified version of the basket array
 */
	public static function flagPromotionalItems($basket = array()) {
		if (! empty($basket['BasketItem'])) {
			foreach ($basket['BasketItem'] as &$item) {
				// if BasketItemData is available, loop around and search
				// for a promotion_id entry
				if (! empty($item['BasketItemData'])) {
					foreach ($item['BasketItemData'] as $basketItemData) {
						if (
							(
								! empty($basketItemData['name']) &&
								$basketItemData['name'] == 'promotion_id'
							) &&
							! empty($basketItemData['item_data'])
						) {
							$item['is_promotional'] = true;
							break;
						}
					}
				}
			}
		}

		return $basket;
	}
}
