<?php

App::uses('DiscountCodesController', 'EvDiscount.Controller');

class PromotionsController extends DiscountCodesController {

/**
 * Paginator defaults for admin.
 *
 * @var array
 */
	public $adminPaginate = array(
		'contain' => array(
			'Currency'
		)
	);

/**
 * Defines the fields displayed in a admin edit form
 *
 * @return array Contains the fields to display on the amdin edit form
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$Model = $this->{$this->modelClass};

		// if not already set, add a note to the amount field to explain its purpose
		if (
			isset($fields[$Model->alias . '.amount']) &&
			empty($fields[$Model->alias . '.amount']['displayInfo'])
		) {
			$fields[$Model->alias . '.amount']['displayInfo'] = 'Specify how many of the qualifying items should be purchased before a promotion is applied.';
		}

		// unset the unused fields from discounts
		unset(
			$fields[$Model->alias . '.times_used'],
			$fields[$Model->alias . '.maximum_uses'],
			$fields[$Model->alias . '.is_voucher']
		);

		return $fields;
	}

/**
 * Defines the fields displayed in a filter form.
 *
 * @return array Contains the fields to display on the amdin filter form
 */
	protected function _adminFilterFields() {
		$fields = parent::_adminFilterFields();

		$Model = $this->{$this->modelClass};

		// Unset the code filter - promotions don't have codes
		unset($fields[$Model->alias . '.code']);

		return $fields;
	}

/**
 * Defines the columns to displayed on the admin index
 *
 * @return array Contains the columns to display on the amdin index
 */
	protected function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();

		$Model = $this->{$this->modelClass};

		// Unset the code filter - promotions don't have codes
		unset($columns[$Model->alias . '.code']);

		return $columns;
	}

}


