<?php

App::uses('CakeTime', 'Utility');
App::uses('AppShell', 'Console/Command');
App::Uses('ProductCacheLib', 'EvPromotion.Lib');

class ClearProductCacheShell extends AppShell {

	public $uses = [
		'EvPromotion.Promotion',
		'EvShop.Product',
		'EvShop.CategoriesProduct',
		'EvDiscount.CodeRestriction'
	];

/**
 * Redefine startup to set some default params
 */
	public function startup() {
		parent::startup();

		$this->ProductCacheLib = new ProductCacheLib();
	}

/**
 * Clear all caches for promotions that ended upto 1 day ago
 */
	public function daily() {
		$dateRange = CakeTime::daysAsSql('-1 day', 'NOW', 'Promotion.end_date');
		$this->ProductCacheLib->flush($dateRange);
	}

/**
 * Clear all caches for promotions that ended upto 1 hour ago
 */
	public function hourly() {
		$dateRange = CakeTime::daysAsSql('-1 hour', 'NOW', 'Promotion.end_date');
		$this->ProductCacheLib->flush($dateRange);
	}

/**
 * Clear all caches for promotions that ended upto 1 week ago
 */
	public function weekly() {
		$dateRange = CakeTime::daysAsSql('-1 week', 'NOW', 'Promotion.end_date');
		$this->ProductCacheLib->flush($dateRange);
	}
}
