<?php
class AddPromotionsTable extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_promotions_table';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'ev_promotion_promotions' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'primary'),
					'discount_type_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false),
					'name' => array('type' => 'string', 'null' => false, 'collate' => 'utf8mb4_unicode_ci', 'charset' => 'utf8mb4'),
					'start_date' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'end_date' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'min_order' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
					'amount' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
					'currency_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'extra_data' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_unicode_ci', 'charset' => 'utf8mb4'),
					'is_active' => array('type' => 'boolean', 'null' => true, 'default' => null),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_unicode_ci', 'engine' => 'InnoDB'),
				),
			),
		),
		'down' => array(
			'drop_table' => array(
				'ev_promotion_promotions'
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
