<?php

	App::uses('CakeEventListener', 'Event');

	class PostcodeSurchargeListener implements CakeEventListener {

		public function implementedEvents() {
			return array(
				'Model.Order.updateOrderTotal' => 'calculateDeliverySurchargeCost',
			);
		}

		public function calculateDeliverySurchargeCost(CakeEvent $event) {
			
			//Check to see if the delivery address has been set on the order?
			$data = $event->data['Order'];

			if(! empty($data['DeliveryAddress']['postcode'])) {

				$PostcodeSurcharge = ClassRegistry::init('EvPostcodeSurcharge.PostcodeSurcharge');
				$postcodeSurcharge = $PostcodeSurcharge->calculateSurcharge($data['DeliveryAddress']['postcode']);

				if($postcodeSurcharge) {

					$subtotal = $postcodeSurcharge['PostcodeSurcharge']['surcharge'];
					$vat = $postcodeSurcharge['PostcodeSurcharge']['vat'];
					$total = $postcodeSurcharge['PostcodeSurcharge']['vat'] + $postcodeSurcharge['PostcodeSurcharge']['surcharge'];

					$event->data['Order']['Order']['surcharge_subtotal'] = $subtotal;
					$event->data['Order']['Order']['surcharge_vat'] = $vat;
					$event->data['Order']['Order']['surcharge_total'] = $postcodeSurcharge['PostcodeSurcharge']['vat'] + $postcodeSurcharge['PostcodeSurcharge']['surcharge'];

					$event->data['Order']['Order']['total'] += $total;
					$event->data['Order']['Order']['vat'] += $vat;

				}
				
			}


		}

	}
