<?php
class PostcodeSurchargesController extends AppController {

	public function beforeFilter() {

		parent::beforeFilter();

		$this->admin_menu_flag = 'PostcodeSurcharge';
	}


	/**
	 * Defines which actions are available to each row of the admin_index table results
	 *
	 * Override in your controller to customise
	 * Customise the handlers for these actions in /view/Admin/Elements/index_results.ctp
	 */
	public function _adminIndexActions() {

		return array(
			'Delete',
			'Edit'
		);

	}


	/**
	 * Defines the columns displayed in the admin_index results table
	 * By default, this includes every column in the db table
	 *
	 */
	public function _adminIndexColumns() {

		$Model = $this->{$this->modelClass};
		$columns = parent::_adminIndexColumns();

		unset($columns[$Model->alias.'.id']);

		return $columns;

	}


	/**
	 * Defines the fields displayed in a filter form
	 *
	 * Defaults to all fields in the db table
	 *
	 * Override in your controller to customise
	 *
	 * Format:
	 *
	 * "id"=>array(
	 * 		"label"=>"label text",
	 * 		"type"=>"type of control to render: text, select etc.",
	 * 		"compare"=>"SQL query. e.g. Model.field='%s' (where %s is replace by the value of the field)"
	 * )
	 */
	public function _adminFilterFields() {

		$Model = $this->{$this->modelClass};
		$fields = parent::_adminFilterFields(); 

		unset($fields[$Model->alias.'.id']);
		unset($fields[$Model->alias.'.surcharge']);
		unset($fields[$Model->alias.'.postcode_district_start']);
		unset($fields[$Model->alias.'.postcode_district_end']);

		return $fields;

	}

}