<table cellpadding="0" cellspacing="0" id="poll_option_table">
	<thead>
		<tr>
			<th>Answer</th>
			<th>Current Votes</th>
			<th>Current Percentage</th>
			<th>&nbsp;</th>
		</tr>
	</thead>
	<tbody id="poll_option_body">
		<?php $loopCounter = 0; ?>
		<?php if (isset($this->data['PollOption'])): ?>
			<?php foreach ($this->data['PollOption'] as $pollOption): ?>
				<tr class="poll-row">
					<td>
						<?= $this->Form->addField('PollOption.' . $loopCounter . '.id', [
							'type' => 'hidden',
							'value' => $pollOption['id'],
							'class' => 'poll-option-id',
							'id' => 'poll_option_' . $loopCounter
						]); ?>

						<?= $this->Form->addField('PollOption.' . $loopCounter . '.answer', [
							'type' => 'string',
							'value' => $pollOption['answer'],
							'label' => false
						]); ?>
					</td>
					<td class="poll-votes">
						<span><?= $pollOption['votes']; ?></span> / <?= $this->data['Poll']['total']; ?>
					</td>
					<td class="poll-results">
						<span class="poll-results__outer">
							<span class="poll-results__inner" style="width: <?= $pollOption['percent']; ?>%">
								<?= number_format($pollOption['percent'], 1); ?>%
							</span>
						</span>

					</td>
					<td class="poll-delete">
						<i class="fa fa-close"></i>
					</td>
				</tr>
				<?php $loopCounter++; ?>
			<?php endforeach; ?>
		<?php endif; ?>
	</tbody>
</table>

<input type="hidden" id="poll_loop" value="<?= $loopCounter; ?>" />

<span id="add_poll_option" class="btn btn-primary">Add a new answer</span>

<style type="text/css">
	.poll-row {
		border-bottom: 1px solid #cccccc;
	}

	.poll-row .form-group {
		margin-bottom: 0;
	}

	.poll-votes {
		width: 150px;
	}

	.poll-votes span {
		font-size: 22px;
		font-weight: bold;
		color: #344A80;
	}

	.poll-results {
		padding: 5px;
	}

	.poll-results__outer {
		overflow: hidden;
		display: block;
		width: 100%;
		height: 34px;
		background-color: #cccccc;
		border-radius: 17px;
	}

	.poll-results__inner {
		display: block;
		height: 34px;
		padding-top: 4px;
		background-color: #6DB4F7;
		color: #000000;
		font-size: 16px;
		font-weight: bold;
		text-indent: 10px;
	}

	.poll-delete {
		font-size: 24px;
		color: #cc0000;
		text-align: right;
		cursor: pointer;
	}

	#add_poll_option {
		cursor: pointer;
	}
</style>

<script type="text/javascript">

	window.onload = function() {
		$('#add_poll_option').on('click', function() {
			$.ajax({
				'url': '/ev_poll/polls/get_admin_poll_row_template/' + $('#poll_loop').val(),
				'success': function(data) {
					$('#poll_option_body').append(data);
					pollLoopVal = parseInt($('#poll_loop').val());
					pollLoopVal++;
					$('#poll_loop').val(pollLoopVal);
				}
			});
		});

		$(document).on('click', '.poll-delete', function() {
			if(confirm('Are you sure you wish to remove this option? Any results associated with this option will also be lost.')) {
				if ($(this).parent('tr').find('.poll-option-id').length) {
					pollOptionID = $(this).parent('tr').find('.poll-option-id').val();

					$.ajax({
						'url': '/ev_poll/poll_options/delete_option/' + pollOptionID
					});
				}

				$(this).parents('tr').remove();
			}
		});
	}
</script>