<?php
App::uses('EvPollAppModel', 'EvPoll.Model');
/**
 * PollOption Model
 */
class PollOption extends EvPollAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'answer';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'poll_id' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				'message' => 'Please select the poll this answer is for'
			),
		),
		'answer' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Please enter the option answer'
			),
		),
	);

	// The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'Poll' => array(
			'className' => 'EvPoll.Poll',
			'foreignKey' => 'poll_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);
}
