<?php
App::uses('EvPollAppModel', 'EvPoll.Model');
/**
 * Poll Model
 */
class Poll extends EvPollAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Please enter a name'
			),
		),
		'question' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Please enter the question'
			),
		),
	);

	// The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'PollOption' => array(
			'className' => 'EvPoll.PollOption',
			'foreignKey' => 'poll_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);

	public function afterFind($results, $primary = false) {
		foreach ($results as $resultIndex => $result) {
			if (isset($result['PollOption'])) {
				$votes = Hash::extract($result['PollOption'], '{n}.votes');
				$voteCount = array_sum($votes);
				$results[$resultIndex]['Poll']['total'] = $voteCount;

				foreach ($result['PollOption'] as $pollOptionIndex => $pollOption) {
					if ($voteCount > 0) {
						$results[$resultIndex]['PollOption'][$pollOptionIndex]['percent'] = (100 / $voteCount) * $pollOption['votes'];
					} else {
						$results[$resultIndex]['PollOption'][$pollOptionIndex]['percent'] = 0;
					}
				}
			}
		}

		return $results;
	}

	public function readForView($id, $params = array()) {
		$params['contain'][] = 'PollOption';

		return parent::readForView($id, $params);
	}

	public function readForEdit($id, $params = array()) {
		$params['contain'][] = 'PollOption';

		return parent::readForEdit($id, $params);
	}

	/**
	 * Increment a poll option vote value
	 */
	public function answer($pollOptionID) {
		$pollOption = $this->PollOption->find('first', [
			'conditions' => [
				'PollOption.id' => $pollOptionID
			],
			'fields' => [
				'votes'
			]
		]);

		$votes = 0;

		if ($pollOption['PollOption']['votes'] !== null) {
			$votes = $pollOption['PollOption']['votes'];
		}

		$votes++;

		$this->PollOption->id = $pollOptionID;
		$this->PollOption->set('votes', $votes);
		$this->PollOption->save();
	}
}
