<?php

App::uses('EvPollAppController', 'EvPoll.Controller');

class PollsController extends EvPollAppController {

	public $components = [
		'Cookie'
	];

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow([
			'submit'
		]);

		//$this->Cookie->name = 'EvPoll';
		$this->Cookie->time = 60 * 60 * 24 * 365;
		$this->Cookie->path = '/';
	}

	/**
	 * Manages an admin edit form for this model
	 *
	 * @param integer $id ID of row to edit
	 * @return void
	 */
	public function admin_edit($id = null) {
		parent::admin_edit($id);
		$this->view = 'EvPoll.Polls/admin_edit';
	}

	/**
	 * Submit a poll answer
	 */
	public function submit() {
		if ($this->request->is('post')) {
			// Process submission
			$Model = $this->{$this->modelClass};
			$modelAlias = $Model->alias;

			$pollID = $this->request->data['pollID'];
			$pollAnswer = $this->request->data['pollAnswer'];

			$Model->answer($pollAnswer);

			// Return answer
			$poll = $Model->readForView($pollID);
			$this->set('poll', $poll['Poll']);
			$this->set('pollOptions', $poll['PollOption']);

			// Set cookie to prevent user from taking poll again
			$this->Cookie->write('EvPoll.' . $pollID, true, false, '1 year');

			$this->layout = 'ajax';
			$this->view = 'EvPoll.Elements/poll_answer';
		}
	}

	/**
	 * Admin Poll row template fetch
	 */
	public function get_admin_poll_row_template($increment) {
		$this->set('increment', $increment);
		$this->layout = 'ajax';
		$this->view = 'EvPoll.Elements/admin_poll_row';
	}
}
