<?php

class PollOptionsController extends EvPollAppController {

	protected function _adminPopulateLookups() {
		$this->loadModel('EvPoll.Poll');
		$this->set('polls', $this->Poll->find('list', [
			'order' => 'name ASC'
		]));
	}

	protected function _adminFilterFields() {
		$fields = parent::_adminFilterFields();

		$newFields = [
			'PollOption.poll_id' => [
				'label' => 'Poll',
				'type' => 'select',
				'compare' => [
					'poll_id' => "%s"
				]
			]
		];

		$fields = ArrayUtil::addAfter($newFields, 'PollOption.answer', $fields);

		return $fields;
	}

	protected function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();

		$newColumns = [
			'Poll.name' => [
				'label' => 'Poll',
				'type' => 'string'
			]
		];

		$columns = ArrayUtil::addAfter($columns, 'PollOption.id', $newColumns);

		return $columns;
	}

	protected function _adminIndexPaginate() {
		$params = parent::_adminIndexPaginate();

		$params['contain'][] = 'Poll';

		return $params;
	}

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		unset($fields['PollOption.votes']);

		return $fields;
	}

	public function delete_option($id) {
		$Model = $this->{$this->modelClass}->delete($id);
		die();
	}
}