<?php

App::uses('AppHelper', 'View/Helper');

class PhoneNumberHelper extends AppHelper {

/**
 * Creates an HTML link to a telephone number.
 * @param string $title The content to be wrapped by `<a>` tags
 * @param string $telNumber Phone number
 * @param array $options Array of options and HTML attributes. Extra options include countryCode which defaults to 'GB' and alwaysLink which will force creating the link when not on a mobile device.
 * @return string An `<a />` element or just the telephone number for non-mobile devices
 */
	public function link($title, $telNumber = null, $options = []) {
		$telNumber = $telNumber ?: $title;
		$countryCode = !empty($options['countryCode']) ? $options['countryCode'] : 'GB';
		unset($options['countryCode']);

		App::uses('CakeRequest', 'Utility');
		if (!(new CakeRequest())->is('mobile') && empty($options['alwaysLink'])) {
			return $this->Html->tag('span', $title, $options);
		}
		unset($options['alwaysLink']);

		$phoneNumber = $this->parse( $telNumber, $countryCode );
		return $this->Html->link($title, 'tel:' . $phoneNumber, $options);
	}

/**
 * Sanitises a phone number string to a number that can be used in a tel link
 * @param string $telNumber Phone number
 * @param array $countryCode Defaults to 'GB'
 * @return string The phone number in a form that can be used in a tel link
 */
	public function parse($telNumber, $countryCode = 'GB') {
		$phoneUtil = \libphonenumber\PhoneNumberUtil::getInstance();
		$tel = $phoneUtil->parse($telNumber, $countryCode);
		return '+' . $tel->getCountryCode() . $tel->getNationalNumber();
	}
}
