// If this returns false or the card fields aren't visible, see Step #1.
(function() {
	if (paypal.HostedFields.isEligible()) {

		var $container = $('#paypal-card-form-container');
		var address = $container.data('shipping-address');
		$billToDeliveryAddress = $('#BillingAddressSameAsDelivery');
		var orderId = null;

		// Renders card fields
		paypal.HostedFields.render({
			// Call your server to set up the transaction
			createOrder: function () {
				$.ajax('/ajax/ev_paypal/paypal_onsite/create_order', {
					method: 'post',
					async: false,
					dataType: 'json',
					data: {
						order: {
							intent: 'CAPTURE',
							purchase_units: [{
								amount: {
									value: $container.data('amount'),
									currency_code: $container.data('currency')
								},
								shipping: {
									name: {
										full_name: $container.data('customer-name'),
									},
									address: {
										address_line_1: address.Address.address1,
										address_line_2: address.Address.address2,
										admin_area_2: address.Address.city,
										admin_area_1: address.Address.county,
										postal_code: address.Address.post_code,
										country_code: address.Country.iso2
									}
								},
								application_context: {
									stored_payment_source: {
										payment_initiator: 'CUSTOMER',
										payment_type: 'ONE_TIME',
										usage: 'DERIVED'
									}
								}
							}],
						},
						hash: $container.data('hash')
					},
					success: function(data) {
						if (data.success) {
							orderId = data.orderId;
						}
					},
					error: function() {
						alert('This page has expired, please refresh the page and try again');
					}
				});

				return orderId;
			},

			styles: window.evPaypalFormOptions.styles,

			fields: {
				number: {
					selector: "#card-number",
					placeholder: "e.g. 4111 1111 1111 1111"
				},
				cvv: {
					selector: "#cvv",
					placeholder: "e.g. 123"
				},
				expirationDate: {
					selector: "#expiration-date",
					placeholder: "MM/YY"
				},
			},

		}).then(function (cardFields) {

			$("#paypal-card-form").on('submit', function (event) {
				event.preventDefault();

				// Check external validation
				if (!validateForm(cardFields.getState()) || !window.evPaypalFormOptions.onSubmit(event)) {
					return false;
				}

				// Hide the buttons to prevent resubmitting
				$('#paypal-buttons-container, #paypal-card-form-container').hide();
				$('#paypal-processing-container').show();

				// Get the billing address if not using the shipping address
				var billingAddress = address;
				if (!$billToDeliveryAddress.is(':checked')) {
					billingAddress = {
						Address: {
							name: document.getElementById('BillingAddressName').value,
							address1: document.getElementById('BillingAddressAddress1').value,
							address2: document.getElementById('BillingAddressAddress2').value,
							city: document.getElementById('BillingAddressCity').value,
							county: document.getElementById('BillingAddressCounty').value,
							post_code: document.getElementById('BillingAddressPostCode').value
						},
						Country: {
							iso2: document.getElementById('BillingAddressCountryCode').value
						}
					}
				}

				cardFields.submit({
					// Enable 3d secure
					contingencies: ['3D_SECURE'],
					// Cardholder's first and last name
					cardholderName: document.getElementById('BillingAddressName').value,
					// Billing Address
					billingAddress: {
						streetAddress: billingAddress.Address.address1,
						extendedAddress: billingAddress.Address.address2,
						locality: billingAddress.Address.city,
						region: billingAddress.Address.county,
						postalCode: billingAddress.Address.post_code,
						countryCodeAlpha2: billingAddress.Country.iso2
					}
				}).then(function () {
					// Payment details successfully submitted
					$($container.data('checkout-form'))
						.remove('.paypal-added-field')
						.append('<input name="data[Paypal][orderId]" type="hidden" value="' + orderId + '" class="paypal-added-field">')
						.append('<input name="data[Paypal][hash]" type="hidden" value="' + $container.data('hash') + '" class="paypal-added-field">')
						.append('<input name="data[Paypal][billingAddress]" type="hidden" value="' + encodeURI(JSON.stringify(billingAddress)) + '" class="paypal-added-field">')
						.trigger('submit');
				}).catch(function (err) {

					// Show the forms again
					$('#paypal-buttons-container, #paypal-card-form-container').show();
					$('#paypal-processing-container').hide();

					// If we have any details about the error highlight the relavent fields
					if (err.details) {
						err.details.forEach(function(error) {
							switch (error.field) {
								case '/payment_source/card/number':
									$('#card-number').addClass('invalid');
									break;
								case '/payment_source/card/expiry':
									$('#expiration-date').addClass('invalid');
									break;
							}
						});
					}
				});
			});
		});

		$billToDeliveryAddress.on('change', function () {
			if (!this.checked) {
				$('#billing-address-container').slideDown();
			} else {
				$('#billing-address-container').slideUp();
			}
		});

		if ($billToDeliveryAddress.is(':checked')) {
			$('#billing-address-container').hide();
		}

	} else {
		// Hides card fields if the merchant isn't eligible
		$('#paypal-card-form-container').hide();
	}

	function validateForm(state) {
		$('#paypal-card-form-container .invalid').removeClass('invalid');
		var valid = true;

		if (!state.fields.cvv.isValid) {
			$('#cvv').addClass('invalid');
			valid = false;
		}

		if (!state.fields.number.isValid) {
			$('#card-number').addClass('invalid');
			valid = false;
		}

		if (!state.fields.expirationDate.isValid) {
			$('#expiration-date').addClass('invalid');
			valid = false;
		}

		$cardHolderName = $('#BillingAddressName');
		if (!$cardHolderName.val()) {
			$cardHolderName.addClass('invalid');
			valid = false;
		}

		var useShippingAddress = $('#BillingAddressSameAsDelivery').is(':checked');
		if (!useShippingAddress) {
			[
				'#BillingAddressAddress1',
				'#BillingAddressCity',
				'#BillingAddressCounty',
				'#BillingAddressPostCode',
				'#BillingAddressCountryCode',
			].forEach(function (identifier) {
				var $field = $(identifier);
				if (!$field.val()) {
					$field.addClass('invalid');
					valid = false;
				}
			});
		}

		return valid;
	}
})();
