//Displays PayPal buttons
(function() {
	var $container = $('#paypal-buttons-container');

	var buttonOptions = window.evPaypalButtonOptions || {};
	buttonOptions.commit = false;
	buttonOptions.createOrder = function(data, actions) {

		var address = $container.data('shipping-address');

		// Set up the details of the transaction
		return actions.order.create({
			intent: 'CAPTURE',
			purchase_units: [{
				amount: {
					value: $container.data('amount')
				},
				shipping: {
					name: {
						full_name: $container.data('customer-name'),
					},
					address: {
						address_line_1: address.Address.address1,
						address_line_2: address.Address.address2,
						admin_area_2: address.Address.city,
						admin_area_1: address.Address.county,
						postal_code: address.Address.post_code,
						country_code: address.Country.iso2
					}
				}
			}],
			// Don't ask the user to provide a shipping address, that is done on the site already
			application_context: {
				shipping_preference: 'SET_PROVIDED_ADDRESS',
				brand_name: $container.data('brand-name')
			},
		});
	};
	buttonOptions.onApprove = function(data, actions) {
		// Hide the buttons to prevent resubmitting
		$('#paypal-buttons-container, #paypal-card-form-container').hide();
		$('#paypal-processing-container').show();

		// Transaction has been approved. Post the ID to the server to be captured
		$($container.data('checkout-form'))
			.remove('.paypal-added-field')
			.append('<input name="data[Paypal][orderId]" type="hidden" value="' + data.orderID + '" class="paypal-added-field">')
			.append('<input name="data[Paypal][hash]" type="hidden" value="' + $container.data('hash') + '" class="paypal-added-field">')
			.trigger('submit');
	};

	paypal.Buttons(buttonOptions).render('#paypal-buttons-container');
})();
